#!/usr/bin/perl
#-----------------------------------------------------------------------------
# This script was build from original file pslogger.cgi
# and modified by Laurent Destailleur.
# It corrects some bugs and add improvments and new features.
# Because pslogger.cgi is GPL, this tool is also GPL.
#-----------------------------------------------------------------------------
use strict;

#-----------------------------------------------------------------------------
# Defines
#-----------------------------------------------------------------------------
use vars qw/ $REVISION $VERSION /;
$REVISION='$Revision: 1.5 $'; $REVISION =~ /\s(.*)\s/; $REVISION=$1;
$VERSION="1.2 (build $REVISION)";
use vars qw/ $logfile $password $timezone $self %FORM /;

# log file
$logfile  = "../logmy/website.log";

# Password to reset logs
$password = "pslogger";

# Offset from GMT time
$timezone = "+0100"; 



###############################
# Script                      #
# Do not edit below this line #
###############################
$self = "http://$ENV{'HTTP_HOST'}$ENV{'REQUEST_URI'}";

my @MonthLib = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");	# MonthLib must be in english because used to translate log date in apache log files


if ($ENV{'GATEWAY_INTERFACE'}) { print "Content-Type: text/plain\n\n"; }

if (! $ENV{'QUERY_STRING'} && $ENV{'REDIRECT_STATUS'} < 400) {
	# If run from command line or as a direct CGI access, return the syntax
	print "----- pslogger script $VERSION  -----\n";
	print "To use this web logger you must:\n";
	print "0- Edit the \$logfile variable of this script.\n";
	print "1- Put this script into your cgi-bin directory.\n";
	print "2- Add the following code at end of each html pages (before the /body) :\n";
	print "\n";
print <<EOF;
<script language="javascript">
var doc=document.location.href;
if (doc.match(/^http/i)!=null) {
document.write('<scr' + 'ipt language="javascript" src="/cgi-bin/pslogger.pl?loc='+escape(document.location)+'&ref='+escape(document.referrer));
if(document.all) { document.write('&size='+document.fileSize); }
	document.write('"></scr' + 'ipt>');
}
</script>
EOF
	print "\n";
	exit;
}


# Run from an HTTP error redirect to log an error hit
if ($ENV{'REDIRECT_STATUS'} >= 400) {
	my $httpcode = $ENV{'REDIRECT_STATUS'};
	$ENV{'DOCUMENT_URI'} = $ENV{'REDIRECT_URL'};
	$ENV{'DOCUMENT_URI'} .= "?$ENV{'REDIRECT_QUERY_STRING'}";
	print "<HTML>\n<head>\n<title>$httpcode Error</title>\n</head>\n<body>\n";
	print "<H1>$httpcode Error</h1><BR>\n";
	if ($ENV{'REDIRECT_STATUS'} == 404) { print "The requested page does not exist.\n"; }
	print "</BODY>\n<HTML>\n";

	my ($nowsec,$nowmin,$nowhour,$nowday,$nowmonth,$nowyear,$nowwday,$nowyday) = localtime(time());
	my $time = sprintf("[%02d/%s/%04d:%02d:%02d:%02d $timezone]",$nowday,$MonthLib[$nowmonth],$nowyear+1900,$nowhour,$nowmin,$nowsec);

	open(LOG, ">>$logfile") || die "Could not open $logfile for writing [$!]";
	print LOG "$ENV{'REMOTE_ADDR'} - - $time \"GET $ENV{'REQUEST_URI'} $ENV{'SERVER_PROTOCOL'}\" $ENV{'REDIRECT_STATUS'} - \"".($ENV{'HTTP_REFERER'}?$ENV{'HTTP_REFERER'}:'-')."\" \"".($ENV{'HTTP_USER_AGENT'}?$ENV{'HTTP_USER_AGENT'}:'-')."\"\n";
	close(LOG);

	exit;
};

# Run from an HTML Tag to log a successfull hit
foreach my $pair (split(/&/, $ENV{'QUERY_STRING'})) {
	my ($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/~!/ ~!/g;
	$FORM{$name} = $value;
}

if (defined($FORM{'reset'}) && $FORM{'reset'} > 0) {
	reset_log();
	exit;
}

# Check and/or Define value for time, FORM{'loc'}, FORM{'size'}, FORM{'ref'}
my ($nowsec,$nowmin,$nowhour,$nowday,$nowmonth,$nowyear,$nowwday,$nowyday) = localtime(time());
my $time = sprintf("[%02d/%s/%04d:%02d:%02d:%02d $timezone]",$nowday,$MonthLib[$nowmonth],$nowyear+1900,$nowhour,$nowmin,$nowsec);

if (! defined($FORM{'loc'})) { $FORM{'loc'}=''; }	# Should not happen
$FORM{'loc'} =~ s/^http:\/\/[^\/]+$/\//;
$FORM{'loc'} =~ s/^http:\/\/[^\/]+\//\//;
if ($FORM{'loc'} eq '/.') { $FORM{'loc'}='/'; }
if ($FORM{'loc'} eq '//') { $FORM{'loc'}='/'; }

if (! defined($FORM{'ref'}) || $FORM{'ref'} eq '' || $FORM{'ref'} eq 'null') { $FORM{'ref'}='-'; }
if (! defined($FORM{'size'}) || $FORM{'size'} eq '' || $FORM{'size'} eq 'undefined') { $FORM{'size'}='-'; }

open(LOG, ">>$logfile") || die "Could not open $logfile for writing [$!]";
flock(LOG, 2);	# Lock
print LOG "$ENV{'REMOTE_ADDR'} - - $time \"GET $FORM{'loc'} $ENV{'SERVER_PROTOCOL'}\" 200 $FORM{'size'} \"$FORM{'ref'}\" \"$ENV{'HTTP_USER_AGENT'}\"\n";
flock(LOG, 8);	# Unlock
close(LOG);
print "document.write();";

0;


sub reset_log {
	if (defined($FORM{'password'}) && $FORM{'password'} eq $password) {
		open(LOG, ">$logfile") || die "Could not reset $logfile [$!]";
		close(LOG);
		print "LOG FILE CLEARED!";
	} else {
		print "INVALID PASSWORD";
	}
	return;
}

