#!usr/bin/perl


# Change the next two lines for your configuration
#my $conf_dir = "e:/awstats/falcfiles";
#my $output_dir = "e:/awstats/logs";

my $conf_dir = "d:/temp";        # location of  awstats062002.www.domain.ie.txt type files
my $output_dir = "d:/temp";   # A directory browsable by http:
my $css = "/css/standard.css"; # Virtual path to css file
my %DOMAIN;
my %FILEMONTHS;
my %MONTHS;
my %YEARS;



my %HITS;
my %BANDWIDTH;
my %VISITS;
my %PAGES; # $pages{$domain}{$dates} ; i.e number of pages for a domain for each date.
my @DATES; # list of all dates read from log files

# print "Content-type: text/html\n\n";
#print "<html>\n";
#print "<head>\n";
#print <<"EOF";
#<title> Welcome to Reports Screen</title>
#<link rel="stylesheet" href="/styles/*.css">
#EOF

#print "</head>\n";
#print "<body>\n";

opendir(DIR, $conf_dir);

my @files = grep { /^awstats.*\.txt$/ } readdir(DIR);



closedir(DIR);

foreach (@files) {
my $domain = $_;
 $domain =~ s/[0-9]//g;
 $domain =~ s/^awstats\.//g;
 $domain =~ s/\.txt$//g;
my $month = $_ ;
 $month =~ s/[a-z]//ig;
 $month =~ s/\.//ig;
 $FILEMONTHS{$month} = 1;
 $DOMAIN{$domain}{$month} = "$_";
}

foreach $month(keys %FILEMONTHS)
{
 foreach $domain(keys %DOMAIN)
 {
  $DOMAIN{$domain}{$month} = "-" , if ($DOMAIN{$domain}{$month} eq "");
print <<"EOF";
$domain : $DOMAIN{$domain}{$month}<br>
EOF

&process_awstats_log_file($DOMAIN{$domain}{$month}, $domain);
 }
}



 foreach $domain(keys %DOMAIN)
 {
  &output_results($domain);
 }

 &output_index_page;






foreach $line(@WARNINGS)
{
print "WARNING : $line\n<br>";
}


#print "</body>\n";
#print "</html>\n";

exit;

sub process_awstats_log_file
{
my $file = $_[0];
my $file = $conf_dir ."/" .  $file; #add directory to file to check
my $domain = $_[1];
my $file_exists = "0";

$file_exists = &check_file_exists($file);

if (!$file_exists)
{
push (@WARNINGS,"File $file for domain $domain not found");
return;
}
my $BEGIN_FOUND = 0;
my $END_FOUND = 0;

open(FILEIN, "$file");
    while (<FILEIN>)
    {
chomp;

$BEGIN_FOUND = 1,next, if ($_ =~ /^BEGIN_DAY/);
$END_FOUND = 1, if ($_ =~ /^END_DAY/);
next ,if($BEGIN_FOUND == 0);
last ,if($END_FOUND == 1);
#    print "$_<br>\n";

my ($date,$pages,$hits,$bandwidth,$visits) = split(/\s/,$_,5);
my $yyyy =substr($date,0,4);
my $mm =substr($date,4,2);
my $dd =substr($date,6,2);

$YEARS{$yyyy} = "1";
$MONTHS{$mm} = "1";

$PAGES{$date}{$domain} += $pages;
$PAGES_YYYY{$domain}{$yyyy} += $pages;
$PAGES_YYYY_MM{$domain}{$yyyy}{$mm} += $pages;
$PAGES_TOTAL{$domain} += $pages;

$HITS{$date}{$domain} += $hits;
$HITS_YYYY{$domain}{$yyyy} += $hits;
$HITS_YYYY_MM{$domain}{$yyyy}{$mm} += $hits;
$HITS_TOTAL{$domain} += $hits;

$BANDWIDTH{$date}{$domain} += $bandwidth;
$BANDWIDTH_YYYY{$domain}{$yyyy} += $bandwidth;
$BANDWIDTH_YYYY_MM{$domain}{$yyyy}{$mm} += $bandwidth;
$BANDWIDTH_TOTAL{$domain} += $bandwidth;

$VISITS{$date}{$domain} += $visits;
$VISITS_YYYY{$domain}{$yyyy} += $visits;
$VISITS_YYYY_MM{$domain}{$yyyy}{$mm} += $visits;
$VISITS_TOTAL{$domain} += $visits;
    }
close(FILEIN);




}

sub print_header
{
my $title = $_[0];
print "<html>\n";
print "<head>\n";
print <<"EOF";
<title> Welcome to Falcon/JWT Reports Screen $title</title>
<link rel="stylesheet" href="$css">
</head>
<body>
EOF
}

sub print_footer
{
print <<"EOF";


</body>
</html>
EOF



}
sub output_results
{
my $domain = $_[0];
my $OUTFILE = $output_dir . "/" . $domain . ".html" ;
open(SAVEOUT, ">&STDOUT");
open (STDOUT ,  ">$OUTFILE") || die "Can't redirect stdout";

$first_time = 0;

foreach $date(sort{ $a <=> $b }keys %PAGES)
{
  if($first_time == 0)
     {
     $first_time++;
     $first_date = $date;
     }
     $last_date = $date;
}
my $last_yyyy =substr($last_date,0,4);
my $last_mm =substr($last_date,4,2);
my $last_dd =substr($last_date,6,2);

my $first_yyyy =substr($first_date,0,4);
my $first_mm =substr($first_date,4,2);
my $first_dd =substr($first_date,6,2);

$first_date = "$first_dd/$first_mm/$first_yyyy";
$last_date = "$last_dd/$last_mm/$last_yyyy";
&print_header($domain);

print <<"EOF";
<div class = header>Dates for which report is valid $first_date to $last_date</div>
<a href = "index.html" class=icon>Return to Index Page</a><br><br>
EOF
&print_monthly_totals($domain);
&print_file_totals($domain);
print "<br><br><br>";

&print_daily_totals($domain);



&print_footer;


select(STDOUT); $| = 1;     # make unbuffered
close(STDOUT);
open(STDOUT, ">&SAVEOUT");
}


sub print_daily_totals
{
my $domain = $_[0];
my $first_time = 0;


foreach $date(sort{ $a <=> $b }keys %PAGES)
{
  if($first_time == 0)
     {
     $first_time++;

   print <<"EOF";
 <div class= header>Daily Statistics for $domain<br></div>
<table border = 0 cellpadding = 0 cellspacing = 2 width = 600>
<tr>
<td class=header>Date</td>
<td class=header>Page Views</td>
<td class=header>Hits</td>
<td class=header>Bandwidth</td>
<td class=header>Visits</td>
</tr>
EOF
}



my $date_value = $date;
my $page_views_value = $PAGES{$date}{$domain};
my $hits_value = $HITS{$date}{$domain};
my $bandwidth_value = $BANDWIDTH{$date}{$domain};
my $visits_value = $VISITS{$date}{$domain};

$visits_value = "--", if ($visits_value  eq "");
$page_views_value = "--", if ($page_views_value  eq "");
$hits_value = "--", if ($hits_value  eq "");
$bandwidth_value = "--", if ($bandwidth_value  eq "");

print <<"EOF";
<tr>
<td class=normal>$date_value</td>
<td class=normal>$page_views_value</td>
<td class=normal>$hits_value</td>
<td class=normal>$bandwidth_value</td>
<td class=normal>$visits_value</td>
</tr>
EOF

}
print "</table>";


}



sub print_monthly_totals
{
my $domain = $_[0];
my $first_time = 0;
foreach $yyyy(sort keys %YEARS)
{
foreach $mm(sort keys %MONTHS)
{



 if($first_time == 0)
     {
     $first_time++;
   print <<"EOF";
 <div class= header>Monthly Statistics for $domain<br></div>
<table border = 0 cellpadding = 0 cellspacing = 2 width = 600>
<tr>
<td class=header>Month</td>
<td class=header>Page Views</td>
<td class=header>Hits</td>
<td class=header>Bandwidth</td>
<td class=header>Visits</td>
</tr>
EOF
    }
print <<"EOF";
<tr>
<td class=heading>$mm/$yyyy</td>
<td class=heading>$PAGES_YYYY_MM{$domain}{$yyyy}{$mm}</td>
<td class=heading>$HITS_YYYY_MM{$domain}{$yyyy}{$mm}</td>
<td class=heading>$BANDWIDTH_YYYY_MM{$domain}{$yyyy}{$mm}</td>
<td class=heading>$VISITS_YYYY_MM{$domain}{$yyyy}{$mm}</td>
</tr>
EOF
}
}



}

sub print_file_totals
{
my $domain = $_[0];
print <<"EOF";
<tr>
<td class=heading>Total</td>
<td class=heading>$PAGES_TOTAL{$domain}</td>
<td class=heading>$HITS_TOTAL{$domain}</td>
<td class=heading>$BANDWIDTH_TOTAL{$domain}</td>
<td class=heading>$VISITS_TOTAL{$domain}</td>
</tr>
</table>
EOF

}









sub output_index_page
{
my $OUTFILE = $output_dir . "/" . "index.html" ;
open(SAVEOUT, ">&STDOUT");
open (STDOUT ,  ">$OUTFILE") || die "Can't redirect stdout into $OUTFILE";
&print_header("Index Page for Web Reports");

print <<"EOF";
<div class = header>Dates for which report is valid $first_date to $last_date</div>
<table border = 0 cellpadding = 0 cellspacing = 2 width = 400>
EOF


foreach $domain(sort keys %DOMAIN)
{
print <<"EOF";
<tr><td class = normal align = left>
<br>
EOF
&print_monthly_totals($domain);
&print_file_totals($domain);
print <<"EOF";
<a href = "$domain\.html"  class=icon >$domain </a><br><br>
</td>
</tr>
EOF

}



print <<"EOF";
</table>
EOF
&print_footer;

select(STDOUT); $| = 1;     # make unbuffered
close(STDOUT);
open(STDOUT, ">&SAVEOUT");




}


sub check_file_exists
{
my $file =$_[0];
return 1,  if (-r "$file");
return 0;
}