#!/usr/local/bin/perl

#
# 日本語版AWStats用検索キーワードデコード + Alphaスクリプト
#
# Modified by makoto_hobbit 2006.4.5

use Jcode;
use Unicode::Japanese;
use Encode::Guess qw/shift-jis euc-jp/;

$GoogleCacheClientIP = "0.0.0.0";	# google cache接続元IPダミー初期値.
$GoogleCacheClientLastIP = "1.1.1.1";	# google cache接続元IPダミー初期値.
$GoogleCurrentCacheID = "abcdefghijkl";	# googleのcache判定変数ダミー初期値.
%GoogleLastCacheID = 0;	# googleのcacheのスタックの初期値.
$YahooCurrentCacheID = "abcdefghij";	# yahooのcache判定変数ダミー初期値.
%YahooLastCacheID = 0;		# yahooのcacheのスタックの初期値.
$MySearchCurrentCacheID = "abcdefghij";	# MySearchのcache判定変数ダミー初期値.
%MySearchLastCacheID = 0;	# MySearchのcacheのスタックの初期値.

$Myhost = $ARGV[0];		# 自ホストのchcheかの判定用. Thanx うちの庭様

while(<STDIN>){
	if (/\\x90\\x02\\xb1\\x02\\xb1\\x02\\xb1\\x02\\xb1/ | /NULL\.IDA\?CCCCCCCCCCCCCCCC/) {
		next;
	}
	& SeparateRefURL; # パラメタ分割
	if (($url =~  /http.*a9\.com/) || ($url =~ /http.*yahoogle\.jp/) || ($url =~ /http.*technorati\.jp/) || ($url =~ /http.*technorati\.com/) || ($url =~ /http.*zero\.squares\.net/) || ($url =~ /http.*search\.rdy\.jp/) || ($url =~ /http.*cros\.spawn\.jp/) || ($url =~ /http.*dir\.fresheye\.com/) || ($url =~ /http\:\/\/iug\.newsing\.jp\/tag/) || ($url =~ /http\:\/\/search\.idol-photo\.com/)) { # パラメタがなくてもサーチエンジンになる場合
		chomp;
		$url =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		$url =~ s/%(2[1345789AC-Eac-e])/pack("H2", $1)/eg;
		$url =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
		if ($url =~ /http.*dir\.fresheye\.com/) {
			$url = Unicode::Japanese->new($url, 'euc')->get;
		} elsif ($url =~ /http.*iug\.newsing\.jp\/tag/)  {
			$url = Unicode::Japanese->new($url, 'euc')->get;
		}
		$_ = $part1 .  $url .  $part3;
		& PrintLine;
	} elsif ($url =~ /\?/) { # パラメタあり
		$url1 = $`;
		$parm = $';
		# googleのキャッシュからのアクセスを、本来に形に戻す.
		if (($url =~ /http.*search.*(\?|\&)q\=cache/) || ($url =~ /216\.239\.(39|41|57|59|63)\.104/) || ($url =~ /64\.233\.1(61|79|67|87)\.104/) || ($url =~ /66\.102\.(7|9|11)\.104/)){
			$parm =~ s/%3A/:/g;
			$parm =~ s/%2F/\//g;
			if ($parm =~ /cache\:([^\:]+)\:(?:.*http\:\/\/|)$Myhost\/([^\+]*[^\&]*)/) {	# CacheIDとキーワードの検出
				# 接続元IPごとにキャッシュIDで判断する.
				$GoogleCurrentCacheID = $1 . $2;
				if (defined($GoogleLastCacheID{$src}) && ($GoogleLastCacheID{$src} eq $GoogleCurrentCacheID)) {	# 既出
				} else { #初出
					$GoogleLastCacheID{$src} = $GoogleCurrentCacheID;
					# 普通のGoogleからのアクセスに認識されるよう変換
					s/%3A/:/g;
					s/%2F/\//g;
					s/(.*\"GET ).*( HTTP[^\"]+\"[^"]+\"http\:\/\/.*(?:\?|\&)q\=cache\:[^\:]+\:)(?:.*http\:\/\/|)$Myhost(\/[^\+]*)((?:\+|%20|\").*)/$1$3$2$4/;
					& SeparateRefURL; # パラメタ分割
					& ReconstructUrl;
					if (($parm =~ /ie\=UTF-8/) && ($parm =~ /%81E/)) { # Bug of Google ???
						;
					} else {
						& DecodeEncodedStringGOOcache;
						&PrintLine;
					}
				}
			} else {	# 自ホストでない場合は無変換
				if ($url =~ /translate/) { # 翻訳の場合
					chomp;
					&PrintLine;
				} elsif (($parm =~ /ie\=UTF-8/) && ($parm =~ /%81E/)) { # Bug of Google ???
					;
				} else {
					& DecodeEncodedStringGOOcache;
					&PrintLine;
				}
			}
		} elsif (($url1 =~ /216\.109\.125\.130\/search\/cache/)||($url1 =~ /66\.218\.69\.11\/search\/cache/)||($url1 =~ /http.*cache\.yahoofs/)){
			if ($parm =~ /$Myhost/) {
				# 一連のcacheかどうかをまず判断する.
				$parm =~ /(\&d\=)(\w{10})/;	# CacheIDの検出
				$YahooCurrentCacheID = $2;
				$parm =~ /\&w\=([^\&]*)/;
				$YahooCurrentCacheID = $YahooCurrentCacheID . $1;
				if (defined($YahooLastCacheID{$src}) && ($YahooLastCacheID{$src} eq $YahooCurrentCacheID)) { # 既出
					;
				} else {	# 初出
					$YahooLastCacheID{$src} = $YahooCurrentCacheID;
					# HTMLファイルのGETを強引に生成, 検索語を検出可能にする
					s/(.*?\"GET )(.*)( HTTP.*(?:\&|\?)u\=$Myhost)(.*)(\&w\=.*)/$1$4$3$4$5/;
					&SeparateRefURL;
					& ReconstructUrl;
					& DecodeEncodedStringYAHOOFSUTF8;
					& DecodeEncodedStringYAHOOfs;
					& PrintLine;
				}
			} else {	# 自ホストでない場合は無変換
				& DecodeEncodedStringYAHOOFSUTF8;
				& DecodeEncodedStringYAHOOfs;
				& PrintLine;
			}
		} elsif ($url1 =~ /http.*kd\.mysearch\.myway\.com\/jsp\/GGcres\.jsp/){
			if ($parm =~ /$Myhost/) {
				# 一連のcacheかどうかをまず判断する.
				$parm =~ /(id\=)(\w{12})/;	# CacheIDの検出
				$MySearchCurrentCacheID = $2;
				if (defined($MySearchLastCacheID{$src}) && ($MySearchLastCacheID{$src} eq $MySearchCurrentCacheID)) { # 既出
					;
				} else {	# 初出
					$MySearchLastCacheID{$src} = $MySearchCurrentCacheID;
					# HTMLファイルのGETを強引に生成, 検索語を検出可能にする
					s/(.*?\"GET ).*( HTTP[^"]*" [^"]*"http.*kd\.mysearch\.myway\.com\/jsp\/.*\.jsp\?).*\&u=http%3A\/\/$Myhost\/(.*)(\&searchfor\=.*)/$1$3$2$4/;
					&SeparateRefURL;
					& ReconstructUrl;
					& DecodeEncodedStringYAHOOFSUTF8;
					& DecodeEncodedStringYAHOOfs;
					& PrintLine;
				}
			} else {	# 自ホストでない場合は無変換
				& DecodeEncodedStringYAHOOFSUTF8;
				& DecodeEncodedStringYAHOOfs;
				& PrintLine;
			}
		} elsif ($url1 =~ /http.*kr\.search\.yahoo\./){
			& DecodeEncodedStringYAHOOkr;
			& PrintLine;
		} elsif ($url1 =~ /http.*hk\.search\.yahoo\./){
			& DecodeEncodedStringYAHOOhk;
			& PrintLine;
		} elsif ($url1 =~ /http.*tw\..*search\.yahoo\./){
			& DecodeEncodedStringYAHOOtw;
			& PrintLine;
		} elsif ($url1 =~ /http.*pctrans\.mobile\.yahoo\.co\.jp/){
			& DecodeEncodedStringYAHOOpctrmobjp;
			& PrintLine;
		} elsif ($url1 =~ /http.*mobile\.yahoo\.co\.jp/){
			& DecodeEncodedStringYAHOOmobjp;
			& PrintLine;
		} elsif ($url1 =~ /http.*search.*\.yahoo\.co\.jp/){
			& DecodeEncodedStringYAHOOjp;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.yahoo\./ || /216\.109\.125\.130/){
			& DecodeEncodedStringYAHOOUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.blogs\.yahoo\.co\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.yahoo-search\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*bsearch\.goo\.ne/){
#			& DecodeEncodedStringUTF8;
			& DecodeEncodedStringGOO;
#			& DecodeEncodedStringGOOMT;
#			& DecodeEncodedStringGOOMT;
			chomp;
			& PrintLine;
		} elsif ($url1 =~ /http.*blog\.search\.goo\.ne/){
			& DecodeEncodedStringGOOblog;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.goo\.ne/){
#			& DecodeEncodedStringUTF8;
			& DecodeEncodedStringGOO;
#			& DecodeEncodedStringGOOMT;
#			& DecodeEncodedStringGOOMT;
			& PrintLine;
		} elsif ($url1 =~ /http.*mobile\.goo\.ne\.jp/){
			& DecodeEncodedStringGooMobile;
#			& DecodeEncodedStringGOO;
#			& DecodeEncodedStringGOOMT;
#			& DecodeEncodedStringGOOMT;
			& PrintLine;
		} elsif ($url1 =~ /http.*\.goo\.ne\.jp/){
			& DecodeEncodedStringGOO;
			& PrintLine;
		} elsif ($url1 =~ /http.*images\.google\./){
			& DecodeEncodedStringImageGoogle;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.google\./){
			if ($parm =~ /%3F%3F%3F/) { # ごみ??
				;
			} else {
				& DecodeEncodedStringUTF8google;
				& PrintLine;
			}
		} elsif ($url1 =~ /http.*search\.msn\.com/){
			& DecodeEncodedStringMSNcomUTF8;
			& DecodeEncodedStringMSN;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.msn\./){
			& DecodeEncodedStringMSNUTF8;
			& DecodeEncodedStringMSN;
			& PrintLine;
		} elsif ($url1 =~ /http.*imagesearch\.excite\.co\.jp/){
			chomp;
			& PrintLine;
		} elsif ($url1 =~ /http.*excite\.co\.jp/){
			& DecodeEncodedStringExcite;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.live\.com/){
			& DecodeEncodedStringLive;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.livedoor\.com/){
			& DecodeEncodedStringLivedoor;
			& PrintLine;
		} elsif ($url1 =~ /http.*home\.search\.biglobe\.ne\.jp/){
			& DecodeEncodedStringBiglobeHome;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.biglobe\.ne\.jp/){
			& DecodeEncodedStringBiglobe;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.infoseek\.co\.jp/){
			& DecodeEncodedStringInfoseek;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.naver\.com/){
			& DecodeEncodedStringNaver;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.naver\.co\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.dir\.bg/){
			& DecodeEncodedStringDirbg;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.ialportal\.com/){
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.osaifu\.com/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.auone\.jp/){
			& DecodeEncodedStringAuone;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.nifty\.com/){
			& DecodeEncodedStringNifty;
			& PrintLine;
		} elsif ($url1 =~ /http.*websearch\.asahi\.com/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.kbg\.jp/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.jp\.aol\.com/){
			& DecodeEncodedString;
			& PrintLine;
		} elsif ($url1 =~ /http.*ceek\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.fresheye\.com/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*bach\.istc\.kobe-u\.ac\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.alltheweb\.com/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*msn\./){
			& DecodeEncodedStringNoConvert;
			& PrintLine;
		} elsif ($url1 =~ /http.*altavista\.com/){
			& DecodeEncodedStringNoConvert;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.marsflag\.com/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*ask\.jp/){
			& DecodeEncodedStringAsk;
			& PrintLine;
		} elsif ($url1 =~ /http.*\.cometsystems\.com/){
			& DecodeEncodedStringNoConvert;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.gbg\.bg/){
			& DecodeEncodedStringW1251;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.jword\.jp/){
			& DecodeEncodedStringJword;
			& PrintLine;
		} elsif ($url1 =~ /http.*(wip|kaikatsu)\.jword\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*(nexyzbb|manga-o-koku|kouziro|cannonball-shop|jiqoo|v-buster|mpo|t-com|cybac|manboo|tnc|timeskk)\.jword\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.t-com\.ne\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*seek\.3721\.com/){
			& DecodeEncodedStringGB2321;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.hatena\.ne\.jp/){
			& DecodeEncodedStringHatena;
			& PrintLine;
		} elsif ($url1 =~ /http.*\.cybozu\.net/){
			& DecodeEncodedStringCybozu;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.filesend\.to/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.warau\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.allabout\.co\.jp/){
			& DecodeEncodedStringAllabout;
			& PrintLine;
		} elsif ($url1 =~ /http.*ezsch\.ezweb\.ne\.jp\/search/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.nyandaful\.jp/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.50pt\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.okodukai\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*research-panel\.jp\/search/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.ecnavi\.jp\/web/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.kaiteki-j\.jp/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.imi\.ne\.jp/){
			& DecodeEncodedStringXUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.highstage\.jp\/sponsor/){
			& DecodeEncodedStringXUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.lifemile\.jp\/sponsor/){
			& DecodeEncodedStringXUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.prize-prize\.com/){
			& DecodeEncodedStringXUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.info-cash\.com/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.fuxima\.com/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*niwango\.jp/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*picmy\.jp/){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*docomo\.ne\.jp\/cp\/as-rslt\.cgi/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.netmile\.co\.jp/){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.conduit\.com/){
			& DecodeEncodedStringXUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.mp3torrent\.org/){
			& DecodeEncodedStringDoubleUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.mp3torrent\.org/){
			& DecodeEncodedStringDoubleUTF8;
			& PrintLine;
		} elsif ($url1 =~ /http.*image\.baidu\.com\//){
			& DecodeEncodedStringBaidu;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.ecnavi\.jp\//){
			& DecodeEncodedStringEUC;
			& PrintLine;
		} elsif ($url1 =~ /http.*search(2|3)\.hiweb\.hitachi\.co\.jp\//){
			& DecodeEncodedStringSJIS;
			& PrintLine;
		} elsif ($url1 =~ /http.*search\.hitachi\.co\.jp\/sitesearch/){
			& DecodeEncodedStringHitachi;
			& PrintLine;
		} elsif ($url1 =~ /http.*cn\.bing\.com\/search/){
			& DecodeEncodedStringBingCN;
			& PrintLine;
		} elsif ($url1 =~ /http.*www\.bing\.com\/search/){
			& DecodeEncodedStringBing;
			& PrintLine;
		} else {
			chomp;
			& PrintLine;
		}
	} else {
		chomp;
		& PrintLine;
	}
}

sub SeparateRefURL {
	s/\\"([^\s])/$1/g;
	/([^ ]+)([^"]*"[^"]*"[^"]*")([^"]*)(".*)/;	# apache 以外の場合変更要？
	$part1 = $1 . $2;
	$src = $1;  # SourceIP
	$url = $3;
	$part3 = $4;
	if ( $src =~ /(\d+\.\d+\.\d+)\.\d+/ ) { # Proxy 対応
		$src = $1;
	}
}

sub ReconstructUrl {
	if ($url =~ /\?/) { # パラメタあり
		$url1 = $`;
		$parm = $';
	}
}

sub PrintLine {
	s/　/%20/g;
	if (Encode::is_utf8($_)) {
		print encode('utf-8',$_);
	} else {
		print;
	}
	print "\n";
}

sub PackPercent {	# %22 を " に変換するとシンタクスエラーになるので
	$parm =~ s/%([1456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
	$parm =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
	$parm =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
}

sub DecodeEncodedStringExcite {
	chomp;
	if ($parm =~ /\\x/) {
		$parm =~ s/\\x/%/g;
		& PackPercent;
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	} else {
		& PackPercent;
		if ($parm =~ /charset\=euc-jp/i) {
			$parm = Unicode::Japanese->new($parm, 'euc')->get;
		} else {
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringSJIS {
	chomp;
	& PackPercent;
	$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringBaidu {
	chomp;
	if ($parm =~ /%/) {
		& PackPercent;
		if ($parm =~ /ie\=utf-8/i) {
			;
		} else {
			Encode::from_to($parm,"GB2312",'utf8');
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringGB2321 {
	chomp;
	& PackPercent;
	Encode::from_to($parm,"GB2312",'utf8');
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringAsk {
	chomp;
	if ($parm =~ /%/) {
		& PackPercent;
		if ($parm =~ /ie\=Shift_JIS/i) {
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		} elsif ($parm =~ /ie\=EUC-JP/i) {
			$parm = Unicode::Japanese->new($parm, 'euc')->get;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringEUC {
	chomp;
	& PackPercent;
	$parm = Unicode::Japanese->new($parm, 'euc')->get;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringHatena {
	chomp;
	& PackPercent;
	if ($parm =~ /ie\=utf8/) {
		;
	} else {
		$parm = Unicode::Japanese->new($parm, 'euc')->get;
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringAuone {
	chomp;
	& PackPercent;
	if ($parm =~ /ie\=utf-8/i) {
		;
	} else {
		$ocode = Jcode::getcode($parm);
		if ($ocode ne undef) { #分からないときはそのまま
			$parm = Unicode::Japanese->new($parm,$ocode)->get;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringJword {
	chomp;
	& PackPercent;
	if ($parm =~ /lang\=euc/) {
		$parm = Unicode::Japanese->new($parm, 'euc')->get;
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringBing {
	chomp;
	if ($parm =~ /%/) {
		& PackPercent;
		$ocode = Encode::Guess->guess($parm);
		if ( ref($ocode) ) {	 # コード判明
			$parm = $ocode->decode($parm);
			utf8::encode($c);
		} elsif ( $ocode =~ /utf8/ ) {	# utf8が候補にある
			;
		} elsif ( $ocode =~ /euc/ ) {
			Encode:from_to($parm,'euc','utf-8');
		} elsif ( $ocode =~ /sjis/ ) {
			Encode:from_to($parm,'sjis','utf-8');
		} else {
			$parm = "";
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}
sub DecodeEncodedStringBingCN {
	chomp;
	if ($parm =~ /q=[%0-9A-Fa-f]+/ ) {
		$parm1 = $`;
		$parm2 = $&;
		$parm3 = $';
		$parm2 =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
		$parm2 =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
		$parm2 =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
		Encode::from_to($parm2,"euc-cn",'utf8');
		$parm = $parm1 . $parm2 . $parm3;
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringAllabout {
	chomp;
	& PackPercent;
	if ($parm =~ /ie\=sjis/) {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringNifty {
	chomp;
	if (( $parm =~ /%[014-9a-fA-F]/ )
		&& (( $parm =~ /((?:\&|^)Text\=)([^\&]+)/ )
			|| ( $parm =~ /((?:\&|^)q\=)([^\&]+)/ )))
		 {
		$mae = $` . $1;
		$a = $2;
		$ato = $';
		$b = $a;
		if ($parm =~ s/cflg\=%B8%A1%BA%F7/cflg=検索/i) {		# euc
			$b =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
			$b =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
			$b =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
			$b = Unicode::Japanese->new($b, 'euc')->get;
		} elsif ($parm =~ s/cflg\=%8C%9F%8D%F5/cflg=検索/i) {	# sjis
			$b =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
			$b =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
			$b =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
			$b = Unicode::Japanese->new($b, 'sjis')->get;
		} elsif ($parm =~ s/cflg\=%E6%A4%9C%E7%B4%A2/cflg=検索/i) { # utf-8
			$b =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
			$b =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
			$b =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
		} elsif ($parm =~ s/cflg\=%1B%24B8%21%3Aw%1B%28B/cflg=検索/i) {	# jis
			while (( $b =~ /%1b%26/i )
				|| ( $b =~ /%1b%24/i )
				|| ( $b =~ /%1b%28/i )) {
				if ( $b =~ /(%1b%26@)/i ) {
					$c =~ $1;
					$d = $c;
					$d =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%24(B|@).*?)%1b/i ) { # 漢字/旧漢字の後エスケープ
					$c = $1;
					$d = $c;
					$d =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%24(B|@).*)/i ) { # 漢字/旧漢字のみ
					$c = $1;
					$d = $c;
					$d =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%28(J|I).*?)%1b/i ) { # JISローマ字/半角カタカナの後エスケープ
					$c = $1;
					$d = $c;
					$d =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%28(J|I).*?)/i ) { # JISローマ字/半角カタカナのみ
					$c = $1;
					$d = $c;
					$d =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%28B.*?)%1b/i ) { # ASCIIの後エスケープ
					$c = $1;
					$d = $c;
					$d =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$d =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
					$d =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				} elsif ( $b =~ /(%1b%28B.*)/i ) { # ASCIIのみ
					$c = $1;
					$d = $c;
					$d =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/ieg;
					$d =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/ieg;
					$d =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/ieg;
					$b =~ s/$c/$d/;
				}
			}
			$b = Unicode::Japanese->new($b, 'jis')->get;
		}
		$a =~ s/\+/\\+/g;
		$parm =~ s/$a/$b/;
		$parm =~ s/submit\=%8C%9F%8D%F5/submit=検索/;
		$parm =~ s/Submit\=%B8%A1%BA%F7/Submit=検索/;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedString {
	chomp;
	$parm =~ s/\\x/%/g;	#googleで"lr=lang_ja"時のデコード対応
	& PackPercent;
	$ocode = Jcode::getcode($parm);
	if ($ocode ne undef) { #分からないときはそのまま
		Jcode::convert(\$parm,'utf8',$ocode);
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	return;
}

sub DecodeEncodedStringUTF8 {
	chomp;
	& PackPercent;
	Jcode::convert(\$parm,'utf8');
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringXUTF8 {
	chomp;
	$parm =~ s/\\x/%/g;
	& PackPercent;
	Jcode::convert(\$parm,'utf8');
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringDoubleUTF8 {
	chomp;
	$parm =~ s/\\x/%/g;
	& PackPercent;
	& PackPercent;
	Jcode::convert(\$parm,'utf8');
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringNoConvert {
	chomp;
	& PackPercent;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringBiglobeHome {
	chomp;
	if ($parm =~ /b=%B8%A1%BA%F7/) { # 検索 in euc
		& PackPercent;
		$parm = Unicode::Japanese->new($parm, 'euc')->get;
	} elsif ($parm =~ /b=%8C%9F%8D%F5/) { # 検索 in sjis
		& PackPercent;
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	} else {
		& PackPercent;
		$ocode = Jcode::getcode($parm);
		if ($ocode ne undef) { #分からないときはそのまま
			$parm = Unicode::Japanese->new($parm,$ocode)->get;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringBiglobe {
	chomp;
	if ($parm =~ /\\x/) {
		$parm =~ s/\\x/%/g;
		& PackPercent;
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	} elsif ($parm =~ /%/) {
		if ($parm =~ /btn=%8C%9F%8D%F5/) { # 検索 in sjis
			& PackPercent;
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		} elsif ($parm =~ /search=%E6%A4%9C%E7%B4%A2/) { # 検索 in utf-8
			& PackPercent;
		} elsif ($url1 =~ /search2\-b/) {
			& PackPercent;
			$parm = Unicode::Japanese->new($parm, 'sjis')->get; # CP 932
		} elsif ($url1 =~ /search2\-db/)  {
			& PackPercent;
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		} elsif ($url1 =~ /search\-iep_lp/)  {
			& PackPercent;
			Jcode::convert(\$parm,'utf8', 'euc');
		} elsif ($url1 =~ /search\-ie2web/)  {
			& PackPercent;
			Jcode::convert(\$parm,'utf8', 'euc');
		} elsif ($url1 =~ /search\-ie_lp/)  {
			& PackPercent;
			Jcode::convert(\$parm,'utf8', 'euc');
		} elsif ($url1 =~ /search\-iep/)  {
			& PackPercent;
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		} elsif ($url1 =~ /search\-ie/)  {
			& PackPercent;
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		} else {
			& PackPercent;
			$ocode = Jcode::getcode($parm);
			if ($ocode ne undef) { #分からないときはそのまま
				$parm = Unicode::Japanese->new($parm,$ocode)->get;
			}
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringGooMobile {
	chomp;
	if ($parm =~ /%/) {
		if ($parm =~ /((?:\&|^)MT\=)([^\&]+)/) {
			$mae = $` . $1;
			$a = $2;
			$ato = $';
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm =~ /IE\=sjis/i) {
				$a = Unicode::Japanese->new($a, 'sjis')->get;
			} else {
				$ocode = Jcode::getcode($a);
				if ($ocode ne undef) { #分からないときはそのまま
					$a = Unicode::Japanese->new($a, $ocode)->get;
				}
			}
			$parm = $mae . $a . $ato;
		} elsif ($parm =~ /((?:\&|^)mt\=)([^\&]+)/) {
			$mae = $` . $1;
			$a = $2;
			$ato = $';
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm =~ /IE\=sjis/i) {
				$a = Unicode::Japanese->new($a, 'sjis')->get;
			} else {
				$ocode = Jcode::getcode($a);
				if ($ocode ne undef) { #分からないときはそのまま
					$a = Unicode::Japanese->new($a, $ocode)->get;
				}
			}
			$parm = $mae . $a . $ato;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringLive {
	chomp;
	if ($parm =~ /((?:\&|^)q\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$ato = $';
		if ($a =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm =~ /cp\=932/i) {
				$a = Unicode::Japanese->new($a, 'sjis')->get;
			}
			$parm = $mae . $a . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringLivedoor {
	chomp;
	& PackPercent;
	if ($parm =~ /ie\=utf8/i) {
		;
	} else {
		$ocode = Jcode::getcode($parm);
		if ($ocode ne undef) { #分からないときはそのまま
			$parm = Unicode::Japanese->new($parm,$ocode)->get;
		}
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringGOOcache {
	chomp;
	& PackPercent;
	if (($parm =~ /ie\=Shift_JIS/i) || ($parm =~ /ie\=sjis/i)) {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	} elsif  ($parm =~ /ie\=EUC-JP/i) {
		Jcode::convert(\$parm,'utf8','euc');
	} elsif  ($parm =~ /ie\=UTF-8/i) {
		;
	} elsif ($parm =~ /start/i) {
		;
	}
#	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringIMGOOUTF8 {
	chomp;
	& PackPercent;
	if ($parm =~ /ie\=Shift_JIS/i) {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	} elsif  ($parm =~ /ie\=EUC-JP/i) {
		Jcode::convert(\$parm,'utf8','euc');
	} elsif  ($parm =~ /ie\=UTF-8/i) {
		;
	} elsif ($parm =~ /%([0-9A-Fa-f])/) {
		if ($1 =~ /[0-7C-Fc-f]/i) {
			;
		} else {
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		}
	}
#	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringImageGoogle {
	chomp;
	if ($parm =~ /%/) {
		if ($parm =~ /((\&|^)q\=)([^\&]+)/) {
			$mae = $` . $1 ;
			$a = $3;
			$b = $a;
			$ato = $';
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$parm = $mae . $a . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringYAHOOUTF8 {
	chomp;
	& PackPercent;
	if ($parm =~ /ei\=UTF-8/i) {
		;
	} else {
		$ocode = Jcode::getcode($parm);
		if ($ocode ne undef) { #分からないときはそのまま
			$parm = Unicode::Japanese->new($parm, $ocode)->get;
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	if ($parm =~ /%/) {
		if ($parm =~ /((%3F|%26|\&|^)p\=)([^\&]+)/) {
			$mae = $` . $1 ;
			$a = $3;
			$b = $a;
			$ato = $';
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$parm = $mae . $a . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringYAHOOhk {
	chomp;
	& PackPercent;
	if ($parm =~ /ei\=BIG5/) {
		use Encode;
		Encode::from_to($parm, "big5", "utf8");
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringW1251 {
	chomp;
	& PackPercent;
	Encode::from_to($parm, "Windows-1251", "utf8");
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringYAHOOtw {
	chomp;
	& PackPercent;
	if ($parm =~ /ei\=BIG-5/i) {
		$a = $parm;
		use Encode;
		if (eval(Encode::from_to($a, "big5", "utf8", Encode::FB_CROAK))) {
			$_ = $part1 .  $url1 . "?" . $a .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringYAHOOkr {
	chomp;
	& PackPercent;
	Encode::from_to($parm, "euc-kr", "utf8");
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringNaver {
	chomp;
	& PackPercent;
	Encode::from_to($parm, "euc-kr", "utf8");
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringDirbg {
	chomp;
	& PackPercent;
	Encode::from_to($parm, "cp1251", "utf8");
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	return;
}

sub DecodeEncodedStringYAHOOjp {
	chomp;
	if ($parm =~ /\\x/) {
		if ($parm =~ /((?:\&|^)p\=)([^\&]+)/) {
			$mae = $` . $1;
			$a = $2;
			$ato = $';
			$a =~ s/\\x/%/g;
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm !~ /fr=slv1-&/) {
				$ocode = Jcode::getcode($a);
					if ($ocode ne undef) {
						$a = Unicode::Japanese->new($a,$ocode)->get;
						$parm = $mae . $a . $ato;
						$_ = $part1 .  $url1 . "?" . $parm .  $part3;
					} else {
						$parm = $mae . $a . $ato;
						$_ = $part1 .  $url1 . "?" . $parm .  $part3;
					}
			}
		}
	} elsif ($parm =~ /%u[0-9a-fA-F]{4}/) {		# %uxxxx は utf16
		while ($parm =~ /(%u([0-9a-fA-F]{4}))/) {
			$a = $1;
			$b = pack("H8","FEFF".$2);			# EncodeはBOMを要求する。
			Encode::from_to($b, "utf16", "utf8");
			$parm =~ s/$a/$b/;
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	} elsif (( $parm =~ /%[014-9a-fA-F]/ ) && ($parm =~ /((?:\&|^)p\=)([^\&]+)/)) {
			$mae = $` . $1;
			$a = $2;
			$ato = $';
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm =~ /ei=EUC\-JP/i) {
				Jcode::convert(\$a, "utf8", "euc");
			} elsif ($parm =~ /ei\=UTF-8/i) {
				;
			} elsif ($parm =~ /ei\=euc-jp/i) {
				Jcode::convert(\$a, "utf8", "euc");
			} elsif ($parm =~ /slv1\-/i) {
				Jcode::convert(\$a, "utf8", "euc");
			} elsif ($url =~ /image-/) {
				;
			} else {
				$ocode = Jcode::getcode($a);
				if ($ocode ne undef) {
					$a = Unicode::Japanese->new($a, $ocode)->get;
				} else {
					Jcode::convert(\$a, "utf8", "euc");
				}
			}
			$parm = $mae . $a . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringYAHOOpctrmobjp {
	chomp;
	& PackPercent;
	if ($parm =~ /(%3Fp\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
		$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
		$c = Unicode::Japanese->new($a, 'sjis')->get;
		$parm = $mae . $c . $ato;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringYAHOOmobjp {
	chomp;
	& PackPercent;
	if ($parm =~ /ei\=UTF-8/) {
		;
	} else {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringYAHOOFSUTF8 {
	chomp;
	& PackPercent;
#	Jcode::convert(\$_,'utf8');
#	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	return;
}

sub DecodeEncodeParameterStringGoogle {
	$mae = $` . $1;
	$a = $2;
	$parmq = $a;
	$b = $a;
	$ato = $';
	$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
	$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
	$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
	if ($parm =~ /btnG\=Google\+%8C%9F%8D%F5/i) {
		$c = Unicode::Japanese->new($a, 'sjis')->get;
	} elsif (($parm =~ /btnG\=Google\+%E6%A4%9C%E7%B4%A2/i) ||
		($parm =~ /btnG\=%E7%B5%9E%E3%82%8A%E8%BE%BC%E3%81%BF%E6%A4%9C%E7%B4%A2/i)) {
		$c = $a;
	} elsif ($parm =~ /btnG\=Google\+%D2%FA%F0%F1%E5%ED%E5/i) {
		$c = $a;
		Encode::from_to($c,"windows-1251",'utf8');
	} elsif ($parm =~ /btnG\=%EA%B5%AC%EA%B8%80\+%EA%B2%80%EC%83%89/i) { # kr utf-8
		$c = $a;
	} elsif ($parm =~ /btnG\=S%C3%B6k/i) { # se utf-8
		$c = $a;
	} elsif ($parm =~ /ie\=EUC[-_]JP/i) {
		$c = Jcode::convert($a,'utf8','euc');
	} elsif ($parm =~ /ie\=windows-1251/i) {
		$c = $a;
		Encode::from_to($c,"windows-1251",'utf8');
	} elsif ($parm =~ /ie\=ISO-8859-2/i) {
		$c = $a;
		Encode::from_to($c,"ISO-8859-2",'utf8');
	} elsif ($parm =~ /ie\=ISO-8859-1/i) {
		$c = $a;
		Encode::from_to($c,"ISO-8859-1",'utf8');
	} elsif (($parm =~ /ie\=Shift_JIS/i) || ($parm =~ /ie\=ShiftJIS/i)||($parm =~ /ie\=SJIS/i)) {
		$c = Unicode::Japanese->new($a, 'sjis')->get;
	} elsif ($parm =~ /oe\=UTF-8/i) {
		$c = $a;
	} elsif ($parm =~ /ie\=GB2312/i) {
		$c = $a;
		Encode::from_to($c,"GB2312",'utf8');
	} else {
		$ocode = Encode::Guess->guess($a);
		if ( ref($ocode) ) {	 # コード判明
			$c = $ocode->decode($a);
			utf8::encode($c);
		} elsif ( $ocode =~ /utf8/ ) {	# utf8が候補にある
			$c = $a;
		} elsif ( $ocode =~ /euc/ ) {
			$c = Unicode::Japanese->new($a, 'euc')->get;
		} elsif ( $ocode =~ /sjis/ ) {
			$c = Unicode::Japanese->new($a, 'sjis')->get;
		} else {
			$c = $parmq;
		}
	}
	$parm = $mae . $c . $ato;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
}

sub DecodeEncodeParameterStringGoogleX {
	$mae = $` . $1;
	$a = $2;
	$b = $a;
	$ato = $';
	$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
	$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
	$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
	$ocode = Encode::Guess->guess($a);
	if ( ref($ocode) ) {	 # コード判明
		$c = $ocode->decode($a);
		utf8::encode($c);
	} elsif ( $ocode =~ /utf8/ ) {	# utf8が候補にある
		$c = $a;
	} elsif ( $ocode =~ /euc/ ) {
		$c = Unicode::Japanese->new($a, 'euc')->get;
	} elsif ( $ocode =~ /sjis/ ) {
		$c = Unicode::Japanese->new($a, 'sjis')->get;
	} else {
		$c = $parmq;
	}
	$parm = $mae . $c . $ato;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
}

sub DecodeEncodedStringUTF8google {
	chomp;
	if ($parm =~ /\\x/) { # \xの場合Apacheの変換。%20があることがある
		$parm =~ s/\\x/%/g;
		if ($parm =~ /((?:\&|^)q\=)([^\&]+)/) {
			&DecodeEncodeParameterStringGoogleX;
		}
		if ($parm =~ /((?:\&|^)as_q\=)([^\&]+)/) {
			&DecodeEncodeParameterStringGoogleX;
		}
		if ($parm =~ /((?:\&|^)as_epq\=)([^\&]+)/) {
			&DecodeEncodeParameterStringGoogleX;
		}
	} elsif ($parm =~ /%/) {
		if ($parm =~ /((?:\&|^)p\=)([^\&]*%[^\&]+)/) {
			&DecodeEncodeParameterStringGoogle;
		}
		if ($parm =~ /((?:\&|^)q\=)([^\&]*%[^\&]+)/) {
			&DecodeEncodeParameterStringGoogle;
		}
		if ($parm =~ /((?:\&|^)q\=)([^\&]*%(?:[01456789A-Fa-f][0-9A-Fa-f]|2[1345789AC-Fac-f]|3[0-9ABCEabce])[^\&]*)/) {
			&DecodeEncodeParameterStringGoogle;
		}
		if ($parm =~ /((?:\&|^)as_q\=)([^\&]*%[^\&]+)/) {
			&DecodeEncodeParameterStringGoogle;
		}
		if ($parm =~ /((?:\&|^)as_epq\=)([^\&]*%[^\&]+)/) {
			&DecodeEncodeParameterStringGoogle;
		}
		if ( $parm =~ s/btnG\=Google\+%8C%9F%8D%F5/btnG=Google+検索/ ) {	# sjis
			;
		} elsif ( $parm =~ s/btnG\=Google\+%E6%A4%9C%E7%B4%A2/btnG=Google+検索/ ) {	# utf-8
			;
		} elsif ( $parm =~ s/btnG\=Google\+%E7%B5%9E%E3%82%8A%E8%BE%BC%E3%81%BF%E6%A4%9C%E7%B4%A/btnG=Google+絞り込み検索utf-8/ ) {	# utf-8
			;
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringCybozu {
	chomp;
	if ($parm =~ /%/) {
		& PackPercent;
		$ocode = Encode::Guess->guess($parm);
		if ( ref($ocode) ) {	 # コード判明
			$parm = $ocode->decode($parm);
			utf8::encode($parm);
		} elsif ( $ocode =~ /euc/ ) {
			$parm = Unicode::Japanese->new($parm, 'euc')->get;
		} elsif ( $ocode =~ /utf8/ ) {	# utf8が候補にある
			;
		} elsif ( $ocode =~ /sjis/ ) {
			$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		}
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}


sub DecodeEncodedStringYAHOOfs {
	chomp;
	if ($parm =~ /(%3fp\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
		$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
		if ($parm =~ /ei\=UTF-8/) {
			$c = $a;
		} else {
			$c = Jcode::convert($a,'utf8','euc');
		}
		$parm = $mae . $c . $ato;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

sub DecodeEncodedStringYAHOO {
	chomp;
	if ($parm =~ /((?:\&|^)p\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
		$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
		if ($parm =~ /ei\=UTF-8/) {
			$c = $a;
		} else {
			$c = Jcode::convert($a,'utf8','euc');
		}
		$_ = $part1 . $mae . $c . $ato . $part3;
		$parm = $mae . $c . $ato;
	}
	return;
}

sub DecodeEncodedStringGOO {
	chomp;
	$parm =~ s/\\x/%/g;
	if ($parm =~ /((?:\&|^)MT\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		if ($b =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			if ($parm =~ /IE=UTF-8/) {
				$c = $a;
			} elsif ($parm =~ /IE=sjis/)  {
				$c = Unicode::Japanese->new($a, 'sjis')->get;
			} else {
				$c = Jcode::convert($a,'utf8','euc');
			}
			$b =~ s/([\+\*\.\?\^\$\[\-\]\|\(\)\\])/\\$1/g;
			$parm = $mae . $c . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringGOOUEMT {
	chomp;
	if ($parm =~ /((?:\&|^)UEMT\=)(%[^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		if ($b =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$c = Jcode::convert($a,'utf8','euc');
			$c =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$c =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$c =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$c = Jcode::convert($c,'utf8','euc');
			$parm = $mae . $c . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringGOOblog {
	chomp;
	if ($parm =~ /((?:\&|^)MT\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		if ($b =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$ocode = Jcode::getcode($a);
			if ($ocode ne undef) { #分からないときはそのまま
				$c = Unicode::Japanese->new($a, $ocode)->get;
			} else {
				$c = $a;
			}
			$parm = $mae . $c . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringGOOMT {
	chomp;
	if ($parm =~ /((?:\&|^)MT\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		if ($b =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$c = Jcode::convert($a,'utf8','euc');
			$parm = $mae . $c . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodedStringMSNcomUTF8 {
	chomp;
	& PackPercent;
	if ($url =~ /results\.asp\?/) {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
#	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	return;
}

sub DecodeEncodedStringMSNUTF8 {
	chomp;
	if ($parm =~ /\\x/) {
		$parm =~ s/\\x/%/g;
	}
	& PackPercent;
	if ($parm =~ /cp\=932/) {
		$parm = Unicode::Japanese->new($parm, 'sjis')->get;
	}
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
#	s/([\x80-\xff][\x80-\xff]|[\x00-\x7f])/($1 eq "\xa1\xa1") ? " " : $1/eg;
	return;
}

sub DecodeEncodedStringMSN {
	chomp;
	if ($parm =~ /(aq\=)([^\&]+)/) {
		$mae = $` . $1;
		$a = $2;
		$b = $a;
		$ato = $';
		if ($b =~ /%/) {
			$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
			$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
			$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
			$parm = $mae . $c . $ato;
			$_ = $part1 .  $url1 . "?" . $parm .  $part3;
		}
	}
	return;
}

sub DecodeEncodeParameterStringInfoseekX {
	$mae = $` . $1;
	$a = $2;
	$b = $a;
	$ato = $';
	$a =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
	$a =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
	$a =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
	if ($parm =~ /enc\=UTF8/i) {
		$c = $a;
	} else {
		$c = Jcode::convert($a,'utf8');
	}
	$parm = $mae . $c . $ato;
	$_ = $part1 .  $url1 . "?" . $parm .  $part3;
}

sub DecodeEncodedStringInfoseek {
	chomp;
	if ($parm =~ /((?:\&|^)qt\=)([^\&]+)/) {
		&DecodeEncodeParameterStringInfoseekX;
	}
	return;
}

sub DecodeEncodedStringHitachi {
	chomp;
	$parm1 = $parm;
	$parm1 =~ s/%([01456789A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
	$parm1 =~ s/%(2[1345789AC-Fac-f])/pack("H2", $1)/eg;
	$parm1 =~ s/%(3[0-9ABCEabce])/pack("H2", $1)/eg;
	$ocode = Encode::Guess->guess($parm1, qw/ shiftjis  7bit-jis /);
	if ( ref($ocode) ) {	 # コード判明
		$parm = $ocode->decode($parm1);
		utf8::encode($parm);
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	} elsif ( $ocode =~ /utf8/ ) {	# utf8が候補にある
		$parm = $parm1;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	} elsif ( $ocode =~ /shiftjis/ ) { # SJIS
		$parm = Unicode::Japanese->new($parm1, 'sjis')->get;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	} elsif ( $ocode =~ /7bit-jis/ ) { # JIS
		$parm = Unicode::Japanese->new($parm1, 'jis')->get;
		$_ = $part1 .  $url1 . "?" . $parm .  $part3;
	}
	return;
}

