(put 'encode-ethio-font 'ccl-program ccl-encode-ethio-font)

(defvar bdf-font-directory-int "c:/Meadow/intlfonts-1.2")
(defvar bdf-font-name-prefix-int "bdffont16-")

(defvar bdf-font-file-alist-int
  '((ascii "European/lt1-16-etl.bdf" 0)
    (japanese-jisx0212 "Japanese/jksp16.bdf" 0)
    (japanese-jisx0208 "Japanese/j90-16.bdf" 0)
    (japanese-jisx0213-1 "Japanese.X/jiskan16-2000-1.bdf" 0)
    (japanese-jisx0213-2 "Japanese.X/jiskan16-2000-2.bdf" 0)
    (latin-jisx0201 "Japanese/8x16rk.bdf" 0)
    (katakana-jisx0201 "Japanese/a18rk.bdf" 1)
    (chinese-big5-1 "Chinese/taipei16.bdf" encode-big5-font)
    (chinese-big5-2 "Chinese/taipei16.bdf" encode-big5-font)
    (chinese-gb2312 "Chinese/guob16.bdf" 0)
    (chinese-cns11643-1 "Chinese/cns-1-16.bdf" 0)
    (chinese-cns11643-2 "Chinese/cns-2-16.bdf" 0)
    (chinese-cns11643-3 "Chinese/cns-3-16.bdf" 0)
    (chinese-cns11643-4 "Chinese/cns-4-16.bdf" 0)
    (chinese-cns11643-5 "Chinese/cns-5-16.bdf" 0)
    (chinese-cns11643-6 "Chinese/cns-6-16.bdf" 0)
    (chinese-cns11643-7 "Chinese/cns-7-16.bdf" 0)
    (chinese-sisheng "Chinese/sish16-etl.bdf" 0)
    (korean-ksc5601 "Korean.X/hanglm16.bdf" 0)
    (thai-tis620 "Asian/thai16.bdf" 1)
    (vietnamese-viscii-upper "Asian/visc16-etl.bdf" encode-viscii-font)
    (vietnamese-viscii-lower "Asian/visc16-etl.bdf" encode-viscii-font)
    (arabic-digit "Misc/arab16-0-etl.bdf" 0)
    (arabic-1-column "Misc/arab16-1-etl.bdf" 0)
    (arabic-2-column "Misc/arab16-2-etl.bdf" 0)
    (ipa "Misc/ipa16-etl.bdf" 1)
    (lao "Asian/lao16-mule.bdf" 1)
    (latin-iso8859-1 "European/lt1-16-etl.bdf" 1)
    (latin-iso8859-2 "European/lt2-16-etl.bdf" 1)
    (latin-iso8859-3 "European/lt3-16-etl.bdf" 1)
    (latin-iso8859-4 "European/lt4-16-etl.bdf" 1)
    (cyrillic-iso8859-5 "European/cyr16-etl.bdf" 1)
    (greek-iso8859-7 "European/grk16-etl.bdf" 1)
    (hebrew-iso8859-8 "Misc/heb16-etl.bdf" 1)
    (latin-iso8859-9 "European/lt5-16-etl.bdf" 1)
    (ethiopic "Ethiopic/ethio16f-uni.bdf" encode-ethio-font)
    (tibetan "Asian/tib16-mule.bdf" 0)
    (tibetan-1-column "Asian/tib1c16-mule.bdf" 0)
    (indian-is13194 "Asian/ind16-mule.bdf" 0)
    (indian-1-column "Asian/ind1c16-mule.bdf" 0)
    (indian-2-column "Asian/ind16-mule.bdf" 0)
    ))

  (new-fontset "int-fontset"
	       (mapcar
		(lambda (x)
		  (let* ((charset (car x))
			 (filename (nth 1 x))
			 (encoding (nth 2 x))
			 (fontname
			  (concat bdf-font-name-prefix-int
				  (symbol-name charset))))
		    (w32-auto-regist-bdf-font
		     fontname
		     (expand-file-name filename bdf-font-directory-int)
		     encoding)
		    (cons charset fontname)))
		bdf-font-file-alist-int))
